model Ex12_1
Real wc(unit="kJ/kg") "Compressor Work: Work Input to Compressor";
Real wt(unit="kJ/kg") "Turbine Work";
Real wnet(unit="kJ/kg") "Net Work";
Real T2(unit="K") "Leaving Air Temperature Compressor";
Real T4(unit="K") "Leaving Air Temperature Turbine";
Real dh21(unit="kJ/kg") "Enthalpy Change Involve for process 1-2";
Real qH(unit="kJ/kg")   "Heat Transferred ";
Real qL(unit="kJ/kg")   "Heat Transferred ";
Real etaTh "Thermal Eficiency";

parameter Real T1(unit="K")=288.2 "Inlet Air Temperature Compressor ";
parameter Real T3(unit="K")=1373.2 "Inlet Temperature Turbine ";
parameter Real P1(unit="MPa ")=0.1 "Inlet Air Pressure Compresssor";
parameter Real P2(unit="MPa ")=1 "Leaving Air Pressure Compressor";
parameter Real P3(unit="MPa ")=1 "Inlet Air Pressure Turbine";
parameter Real P4(unit="MPa ")=0.1 "Leaving Air Pressure Turbine";
parameter Real Cp(unit="kJ/kgK")=1.004 "Specific Heat of air";
parameter Real K=0.286 "Index";

parameter Real h1(unit="kJ/kg")   =394.9 "Enthalpy  of R-134a at state 1 from table at given temperature";
parameter Real h2(unit="kJ/kg")   =480.9 "Enthalpy at state 2 from table at given temperature";
parameter Real h7(unit="kJ/kg")   =256.5 "Enthalpy at state 7 =h5==h6 from table at given temperature";
parameter Real h8(unit="kJ/kg")    =386.6 "Enthalpy at state 8  from table at given temperature";

 equation
 
  // Compressor Work
  T2=T1*((P2/P1)^(0.286));
  dh21=Cp*(T2-T1);
  wc= dh21; 
 
 // Turbine Work
 T4=T3*((P4/P3)^(0.286));
 wt=Cp*(T3-T4);
 
 // Net Work
 wnet=wt-wc;
 
 // Heat To Combustion
 qH=Cp*(T3-T2);
 
 // Heat From Exchanger
 qL=Cp*(T4-T1);
 
 //Thermal Efficiency
 etaTh=wnet/qH;
end Ex12_1;
