model Ex12_2
Real wc(unit="kJ/kg") "Compressor Work: Work Input to Compressor";
Real wt(unit="kJ/kg") "Turbine Work";
Real wnet(unit="kJ/kg") "Net Work";
Real T2s(unit="K") "Leaving Air Temperature Compressor for Ideal Process";
Real T2 "Temperature at outlet for Real Process";
Real T4s(unit="K") "Leaving Air Temperature Turbine for Ideal Process";
Real T4 (unit="K") "Leaving Air Temperature Turbine for Real Process";
Real P3(unit="MPa") "Pressure Entering Turbine";
Real qH(unit="kJ/kg")   "Heat Transferred  Combustion Chamber";
Real etaTh "Thermal Eficiency";


parameter Real etac=0.8 "Compressor Eficiency";
parameter Real etaT=0.85 "Turbine Eficiency";
parameter Real T1(unit="K")=288.2 "Inlet Air Temperature Compressor ";
parameter Real T3(unit="K")=1373.2 "Inlet Temperature Turbine ";
parameter Real P1(unit="MPa ")=0.1 "Inlet Air Pressure Compresssor";
parameter Real P2(unit="MPa ")=1 "Leaving Air Pressure Compressor";
parameter Real dP(unit="Mpa")=0.015 "Pressure Drop";
parameter Real P4(unit="MPa ")=0.1 "Leaving Air Pressure Turbine";
parameter Real Cp(unit="kJ/kgK")=1.004 "Specific Heat of air";
parameter Real K=0.286 "Index";

 equation
 
  // Compressor Work
  T2s=T1*((P2/P1)^(0.286));
  T2=((T2s-T1)/etac)+T1;
  wc=Cp*(T2-T1);
 
  // Turbine Work
  P3=P2-dP;
  T4s=T3*((P4/P3)^(0.286));
  T4 =T3-(etaT*(T3-T4s));
  wt=Cp*(T3-T4);
 
 // Net Work
 wnet=wt-wc;
 
 // Heat Exchange
 qH=Cp*(T3-T2);
 
 //Thermal Efficiency
 etaTh=wnet/qH;
 
end Ex12_2;
