model Ex13_6

Real mN2(unit="kg")"Mass of Nitrogen";
Real mv1(unit="kg")"Mass of Water Vapor";
Real mv2(unit="kg")"Mass of Water Vapor after condensation";
Real ml2(unit="kg")"Mass of Condensed Liquid";
Real Qdotcv(unit="kJ")"Heat Transfer ";

parameter Real  PN2(unit="kPa")=1995 "Partial Pressure of Nitrogen";
parameter Real  Pv1(unit="kPa")=5 "Partial Pressure of water vapor";
parameter Real  Pv2(unit="kPa")=1.2276 "Partial Pressure of water vapor after condensation";
parameter Real  V(unit="m3")=0.5 "Volume of Tank";
parameter Real  RN(unit="kPa")=0.2968 "Value of  Gas Constant for Nitrogen ";
parameter Real  RV(unit="kPa")=0.4615 "Value of  Gas Constant for Water Vapor ";
parameter Real  P1(unit="kPa")=105 "Total Pressure at Inlet";
parameter Real  P2(unit="kPa")=100 "Total Pressure at Outlet";
parameter Real  T1(unit="K")=323.2 " Initial Temperature";
parameter Real  T2(unit="K")=283.2 " Final Vapor Temperature";
parameter Real  Cv(unit="kJ/kgK")=0.745"Specific Heat at constant volume";
parameter Real  hl2(unit="kJ/kg")=62.99 "Enthalpy of liquid at outlet";
parameter Real  hv2(unit="kJ/kg")=2528.9 "Enthalpy of Vapor at outlet";
parameter Real  hv1(unit="kJ/kg")=2556.3 "Enthalpy of Vapor at Inlet";
parameter Real  uv1(unit="kJ/kg")=2443.5 "Internal Energy of water Vapor at Inlet";
parameter Real  uv2(unit="kJ/kg")=2389.2 "Internal Energy of water Vapor at Outlet";
parameter Real  ul2(unit="kJ/kg")=42.0 "Internal Energy of condensed Liquid";

equation

mN2=PN2*V/(RN*T1);
mv1=Pv1*V/(RV*T1);
mv2=Pv2*V/(RV*T2);
ml2=mv1-mv2;

Qdotcv=(mN2*Cv*(T2-T1))+(mv2*uv2)+(ml2*ul2)-(mv1*uv1);

end Ex13_6;
