model Ex15_11

/*This example demonstarte how the enthalpy of combustion of propane varies with temperature*/
/*The Basic Combuston Equation is
C3H8+5O2===>3CO2+4H2O
*/

Real hR500(unit="kJ/kmol")"Enthalpy of Reactants";
Real hP500(unit="kJ/kmol")"Enthalpy of Products";
Real hRP500(unit="kJ/kmol")"Enthalpy of Combustion";
Real hRP500m(unit="kJ/kg")"Enthalpy of Combustion Mass Basis";

parameter Real To(unit="K")=298.2"Standard Temperature";
parameter Real T(unit="K")=500" Product Temperature";
parameter Real MWP=44.097"Molecular wt of Propane";
parameter Real nCO2=3,nH2O=4,nC3H8=1,nO2=5"Coefficeints of Products and Reactants";
parameter Real Cp(unit="kJ/kmolK")=2.1*MWP "Average Specific Heat of Propane mol basis";

parameter Real hfoC3H8g(unit="kJ/kmol")=-103900"Standard Enthalpy of Formation of Propane(G)", hfoH2Og(unit="kJ/kmol")=-241826"Standard Enthalpy of Formation of H2O(G)",hfoCO2(unit="kJ/kmol")=-393522"Standard Enthalpy of Formation of CO2";

parameter Real dhO2(unit="kJ/kmol")=6082"Difference in enthalpy brtween given state and the enthalpy of ideal gas for Oxygen",dhCO2(unit="kJ/kmol")=8305"Difference in enthalpy brtween given state and the enthalpy of ideal gas for Carbon dioxide", dhH2O(unit="kJ/kmol")=6922"Difference in enthalpy brtween given state and the enthalpy of ideal gas for Water" ;

equation
hR500=hfoC3H8g+Cp*(T-To)+nO2*dhO2;
hP500=nCO2*(hfoCO2+dhCO2)+nH2O*(hfoH2Og+dhH2O);
hRP500=hP500-hR500;
hRP500m=hRP500/MWP;

end Ex15_11;
