model Ex15_12

/*The combustion Equation
C8H18(L)+4(12.5)O2+4(12.5)(3.76)N2 ====> 8CO2+9H2O+37.5O2+188.0N2
*/
Real Hp1(unit="kJ/kmol fuel")"Enthalpy of Product Formation at 900 K";
Real Hp2(unit="kJ/kmol fuel")"Enthalpy of Product Formation at 1000 K";
Real Hr(unit="kJ/kmol fuel")"Enthalpy of Reactant";

parameter Real hfo(unit="kJ/kmol")=-250105 "Enthalpy of the reactants";
parameter Real nCO2=8,nH2O=9,nO2=37.5,nN2=188"Coefficeints of Products";
parameter Real hfoCO2=-393522,dhCO2=28030,hfoH2O=-241826,dhH2O=21892,hfoO2=0,dhO2=19249,hfoN2=0,dhN2=18222 "Standard Enthalpy of Formation of Productsat900 K";

parameter Real dh2CO2=33400,dh2H2O=25956,dh2O2=22710,dh2N2=21461 "Standard Enthalpy of Formation of Productsat 1000 K";

equation
Hp1=nCO2*(hfoCO2+dhCO2)+nO2*(hfoO2+dhO2)+nN2*(hfoN2+dhN2)+nH2O*(hfoH2O+dhH2O);
Hp2=nCO2*(hfoCO2+dh2CO2)+nO2*(hfoO2+dh2O2)+nN2*(hfoN2+dh2N2)+nH2O*(hfoH2O+dh2H2O);
Hr=hfo;

/*Hr=Hp as the process is adiabatic*/

/* The Adiabatic Flame temperatue is found by try and error method and our calculation shows it is between 900 and 1000*/

end Ex15_12;
