model Ex15_4

/*aCH4+bO2+cN2--->10CO2+0.53CO+2.37O2+dH2O+87.1N2*/
/*Applying the balance c/b=3.76  ===>> b=23.16*/
/*Carbon Balance: a=10.00+0.53*/
/* Hydrogen Balance: d=2a=21.06*/

/*Simplified equation: 
CH4+2.2O2+8.27N2====>>0.95CO2+0.05CO+2O2+0.2256H2O+8.27N2*/

/*For Calculating Theoretical Air Fuel Ratio
CH4+2O2+2(3.76)N2====>CO2+2H2O+7.52N2*/

Real AF(unit="kg air/kg fuel")"Air Fuel Ratio Mass Basis";
Real AFtheo(unit="kg air/kg fuel")"Theoretical Air Fuel Ratio Mass Basis";
Real ptheoA"Percentage Theoretical Air";

parameter Real CN=8.27"Nitrogen in equation";
parameter Real CO=2.2"Oxygen in equation";
parameter Real MA=28.97"Average Molecular weight of air";
parameter Real MCH4=16"Molecular weight of Methane";
parameter Real CTN=7.52"Nitrogen in equation Theoretical";
parameter Real CTO=2"Oxygen in equation Theoretical";

equation
// Air Fuel  Ratio
AF=(CN+CO)*MA/(MCH4);

// Theoretical Air Fuel Ratio
AFtheo=(CTN+CTO)*MA/(MCH4);

// Percentage Theoretical Air
ptheoA=(AF/AFtheo)*100;


end Ex15_4;
