model Ex16_2

Real dHo(unit="kJ")"Standard Enthalpy change involved";
Real dSo(unit="kJ/K")"Standard Entropy change involved";
Real dGo(unit="kJ")"Standard Gibbs Free change involved";

Real dHo2000(unit="kJ")"Enthalpy change involved between 298.15 K and 2000K";
Real dSo2000(unit="kJ/K")"Entropy change involved between 298.15 K and 2000K";
Real dGo2000(unit="kJ")"Gibbs Free change involved between 298.15 K and 2000K";


parameter Real hfoH2(unit="kJ/kmol")=0"Standard Enthalpy of Formation of C2H4", hfoH2Og(unit="kJ/kmol")=-241826"Standard Enthalpy of Formation of H2O(G)",hfoO2(unit="kJ/kmol")=0"Standard Enthalpy of Formation of Oxygen";

parameter Real sfoH2(unit="kJ/kmol.K")=130.678"Standard Entropy of Formation of C2H4", sfoH2Og(unit="kJ/kmol.K")=188.834"Standard Entropy of Formation of H2O(G)",sfoO2(unit="kJ/kmol.K")=205.148"Standard Entropy of Formation of Oxygen";

parameter Real dhoH22000(unit="kJ/kmol")=52942"Differemce in enthalpy of H2 between 2000 Kand 298.15 K", dhoH2Og2000(unit="kJ/kmol")=-241826+72788"Differemce in enthalpy between 2000 Kand 298.15 K of H2O(G)",dhoO22000(unit="kJ/kmol")=59176"Differemce in enthalpy between 2000 Kand 298.15 K of Oxygen";

parameter Real dsoH22000(unit="kJ/kmol.K")=188.419"Difference in entropy of H2 between 2000 Kand 298.15 K4", dsoH2Og2000(unit="kJ/kmol.K")=264.769"Differemce in enthalpy between 2000 Kand 298.15 K of H2O(G)",dsoO22000(unit="kJ/kmol.K")=268.748"Differemce in enthalpy between 2000 Kand 298.15 K of Oxygen";

parameter Real nH2=2,nH2O=2,nO2=1"Coefficeints of Products and Reactants";
parameter Real To(unit="K")=298.15"Standard Temperature";
parameter Real T(unit="K")=2000"Given Temperature";

equation
dHo=(nH2*hfoH2)+(nO2*hfoO2)-(nH2O*hfoH2Og);
dSo=(nH2*sfoH2)+(nO2*sfoO2)-(nH2O*sfoH2Og);
dGo=dHo-(To*dSo);

dHo2000=(nH2*dhoH22000)+(nO2*dhoO22000)-(nH2O*dhoH2Og2000);
dSo2000=(nH2*dsoH22000)+(nO2*dsoO22000)-(nH2O*dsoH2Og2000);
dGo2000=dHo2000-(T*dSo2000);


end Ex16_2;
