model Ex17_6

Real mdot800(unit="kg/s")"Mass flow rate for back pressure of 800kPa";
Real mdot528(unit="kg/s")"Mass flow rate for back pressure of 528kPa";
Real mdot300(unit="kg/s")"Mass flow rate for back pressure of 300kPa";
Real V(unit="m/s")"Velcoity of Sound at 300 K";
Real VE(unit="m/s")"Velcoity of Sound at 337.7 K";

Real rho528(unit="kg/m3")"Density at 528 kPa and 300 k";
Real rho800(unit="kg/m3")"Density at 800 kPa and 337.7 k";

parameter Real Ae(unit="m2")=500*10^(-6)"Exit Area of Nozzle";
parameter Real Ps(unit="kPa")=1000"Stagnation Pressure";
parameter Real Ts(unit="K")=360"Stagnation Temperature";
parameter Real k=1.4"Value of k for Air";
parameter Real M=1"Mach No.From A.12 for back Pressure of 528 kPa";
parameter Real ME=0.573"Mach No.From A.12 for back Pressure of 800 kPa";
parameter Real Ta(unit="K")=300"Temperature for back Pressure of 528 kPa";
parameter Real TE(unit="K")=337.7"Temperature for back Pressure of 800 kPa";
parameter Real R(unit="kJ/kgK")=0.287"Gas Constant";


equation

// Back  Pressur 528 kPa
rho528=528/(R*Ta);
V=sqrt(k*R*Ta*1000);
mdot528=rho528*Ae*V;

// Back Pressure 800 kPa
rho800=800/(R*TE);
VE=ME*(sqrt(k*R*TE*1000));
mdot800=rho800*Ae*VE;

// Back  Pressure 300 kPa
/* For BackPressure less than Critical Pressure that is 528 kPa, the nozzle is chocked and the mass flow rate is same as that for the critical pressure*/
mdot300=mdot528;

end Ex17_6;
