model Ex5_11

Real dT(unit="K") "Temperature Change";
Real dt(unit="sec") "Time increment";
Real dTdt(unit="K/sec")"Rate of change of Temperature";

parameter Real mair(unit="kg")= 1   "Mass of Air";
parameter Real mwood(unit="kg")= 5  "Mass of Wood";
parameter Real miron(unit="kg")= 25 "Massof Iron";
parameter Real T1(unit="K")= 20+273 " Initial Temperatue of the system";
parameter Real T2(unit="K")= 75+273 " Initial Temperatue of the system";
parameter Real Cvair(unit="kJ/kg")= 0.717 "Specific Heat at constant Volume for air";
parameter Real Cwood(unit="kJ/kg")= 1.38 "Specific Heat for wood ";
parameter Real Ciron(unit="kJ/kg")= 0.42 "Specific Heat for iron";
parameter Real Qdot(unit="W")=1500 "Amount of Heat Released";
    
  equation
  
   dTdt=Qdot/(1000*((mair*Cvair)+(mwood*Cwood)+(miron*Ciron))); /*From Energy Equation: W=0*/
   /* Divided by 1000 for unit Balance from kJ t Joule*/
   
   dT= T2-T1;
   dt=(dT/(dTdt));
   
   /*Total Time required is 664.29 seconds*/
   
end Ex5_11;
