package Ex5_3


/* Q=dU+dKE+dPE+W : First Law for any step */

//======================================================
model Ex5_3_a 
/*The stone is about to enter the water, state  2 */

//======================================================
//Parameter Section
parameter Real m( unit = "kg")= 10 "Mass of Stone";
parameter Real g(unit="m/s2")=9.807 "Acceleration due to gravity";
parameter Real Z2(unit="m")=10.2 "Height above Water";
parameter Real Z1(unit="m/")=0 "Reference Height: water surface";

//======================================================
//Variable Section
Real dKE( unit = "kJ") "Change in Kinetic Energy";
Real dPE( unit = "kJ") "Change in Potential Energy";

//======================================================
//Equation Section
equation
dKE=m*g*(Z2-Z1)/1000 ;/*Part A: dU=0; Q12=0; W12=0*/
dPE=-dKE; /* As dKE+dPE=0 */

end Ex5_3_a ;
//======================================================
//======================================================
model Ex5_3_b 
/* The Stone hasjust come to rest in the bucket, state 3 */

//Parameter Section
parameter Real KE1( unit = "kJ")= 1 "From previous part";
parameter Real KE2( unit = "kJ")= 0 "As stone is at rest";

//======================================================
//Variable Section
Real dKE( unit = "kJ") "Change in Kinetic Energy";
Real dU( unit = "kJ") "Change in Internal Energy";

//======================================================
//Equation Section
equation
dKE=KE2-KE1;
dU = -(dKE) ; /* As dPe=0;Q23=0; W23=0 */

end Ex5_3_b ;
//======================================================
model Ex5_3_c 
/*The stone and water are at sametemperature,T1, state 4 */

// parameter Section
parameter Real U1(unit="kJ")=1"Initial Internal Energy ";
parameter Real U2(unit="kJ")=0"Final Internal Energy ";
//======================================================
//Variable Section
Real dU(unit="kJ")"Change in Internal Energy";
Real Q34(unit = "kJ") "Heat Supplies in step 3 to 4";

//======================================================
//Equation Section
equation
/* There is no KE, PE, and U is same in the state 1*/
dU=U2-U1;
Q34=1*(dU);

end Ex5_3_c ;

//======================================================

end Ex5_3;
