model Ex6_1
Real v( unit = "m3/kg")"Specific Volume";
Real mdot( unit = "kg/s") "Mass Flow Rate";
Real A(unit="m2")"Area";

   
  parameter Real R(unit = "kJ/kgK")=0.287 "Gas Constant";
  parameter Real T(unit = "K") = 298.2 "Temperature";
  parameter Real P(unit = "kPa")=150 "Pressure";
  parameter Real D(unit = "m")=0.2 "Diameter";
  parameter Real V(unit="m/s") =0.1 "Velocity" ;
  final constant Real pi=2*Modelica.Math.asin(1.0)"Valueof pi taken from modelica package";
 
    
equation
  
v=R*T/P;

A=(pi/4)*D^2;
 mdot=V*A/v;
 
end Ex6_1;
