model Ex6_10

Real x4 "Dryness Fraction or Quality of Steam at evaporator inlet";
Real Qdotevap(unit = "kW") "The Rate of Heat Transfer to evaporator";
Real Qdotcomp(unit="kW") "The rate of Heat Transfer to Compressor";

   /*Values of Enthalpies are take from Steam Tables at Given T and P As given below*/
   
  parameter Real h1( unit = "kJ/kg")= 387.2 "Enthalpy at inlet of Compressor";
  parameter Real h2( unit = "kJ/kg")= 435.1 "Enthalpy at Exit of Compressor";
  parameter Real h3( unit = "kJ/kg")= 241.8 "Enthalpy at inlet of Exmansion Valve";
  parameter Real h4( unit = "kJ/kg")= 241.8 "Enthalpy at Exit of Expansion Valve";
  /*h3=h4 because of throttling*/
  parameter Real hf4( unit = "kJ/kg")= 167.4 "Enthalpy of liquid";
  parameter Real hfg4( unit = "kJ/kg")= 215.6 "Enthalpy of Vapor";
 
  
  parameter Real WdotComp(unit = "kW")= -5 "Power Input to the Compressor";
  parameter Real mdot(unit = "kg/s")= 0.1 "Mass Flow Rate of component";
  
    
equation
 
x4=(h4-hf4)/hfg4 "Part A";
Qdotevap=mdot*(h1-h4)"Part B";
Qdotcomp=mdot*(h2-h1)+WdotComp "Part C";


end Ex6_10;
