model Ex6_8
Real Wdot(unit = "kW") "Required Power output from the Pump";


   /*Values of Enthalpies are take from Steam Tables at Given T and P As given below*/
   

  parameter Real g(unit= "m/s2")=9.8066 "Acceleration due to gravity";
 
  parameter Real Zi(unit = "m")=-15 "Height at inlet"; /*Downward from reference therefore negative*/
  parameter Real Ze(unit = "m")=0 "Height at Exit";
  
  parameter Real v(unit= "m3/kg")=0.001001 "Specific Volume";
  
  
  
  /*From continuity equation mass flow rate remains same i.e. mdoti=mdote=mdot*/
  parameter Real mdot(unit"kg/s")=1.5 "Mass flow rate ";
  
  
  parameter Real Pi(unit = "kPa")= 90 "Pressure at inlet";
  parameter Real Pe(unit = "kPa")= 501.3 "Pressure at Exit";  
    
equation
/*From the First law for open System*/
Wdot = mdot*((g*(Zi-Ze)/1000)-(Pe-Pi)*v);
/*Divided by thousand for unit balance*/

/*Answer is negative which shows power is required*/

end Ex6_8;
