model Ex8_7

Real w12(unit="kJ/kg") "Work done";
Real q12( unit = "kJ/kgK") "Heat Transferred";
Real T2( unit = "K") " Final Temperature";
 
  parameter Real T1( unit = "K")= 293.2 " Initial Temperature";
  parameter Real P1( unit = "kPa")= 100 "Initial Pressure";
  parameter Real P2( unit = "kPa")= 500 "Final Pressure";  
  parameter Real R(unit = "kJ/kgK")= 0.2968 "Value of R for Nitrogen";
  parameter Real Cv0( unit = "kJ/kgK")= 0.745 "Specific Heat at Constant Volume";
  parameter Real n=1.3 "From Given equation of Pressure and Volume";
  parameter Real u2(unit="kJ/kg")=328.14 "Value of Internal Energy 2 at 457 K from Table A.7";
    
equation
T2=T1*((P2/P1)^((n-1)/n));/* From Polytropic Process*/
/*Work and Heat Transfer for Polytropic Process*/
w12=R*(T2-T1)/(1-n) ;
q12=Cv0*(T2-T1)+w12;

end Ex8_7;
