model Ex9_6
Real m2(unit="kg") "Mass of Exit Stream";
Real m1(unit="kg") "Mass of Inlet Stream";
Real min(unit="kg") "Exit Mass - Inlet Mass: Accumulated Mass";
Real W12(unit="kJ") "Amount of Work Required";

Real sT2o(unit="kJ/K")"Mass of Inlet ";

/*Values of Entropy and Enthalpy of different straems are calculated from B.1.3 and B.a.2*/
parameter Real sT1o(unit="kJ/kgK")= 6.83521 "Standard Entropy at State 1";
parameter Real hin(unit="kJ/kg")= 290.43 "Enthalpy";
parameter Real u1(unit="kJ/kg")= 207.19 "Internal Energy Associated of inlet Stream";
parameter Real u2(unit="kJ/kg")= 401.49 "Internal Energy Associated of Outlet stream";
parameter Real R(unit="kg/s")= 0.287"Value of Gas Constant";
parameter Real P2(unit="kPa")= 1000 "Exit Pressure";
parameter Real P1(unit="kPa")= 100 "Inlet Pressure";
parameter Real T2(unit="K")= 555.7 "Exit Temperature";
parameter Real T1(unit="K")= 290 "Inlet Temperature";
parameter Real V2(unit="m3")= 0.04 "Exit Volume";
parameter Real V1(unit="m3")= 0.04 "Inlet Volume";

 
  equation
sT2o=sT1o+R*log(P2/P1) ;
m1=P1*V1/(R*T1);
m2=P2*V2/(R*T2);
min=m2-m1;

W12=min*hin+m1*u1-m2*u2;
end Ex9_6;
