// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-10: Open-Channel Flow
//Example: 10.3 Page 574
// Title: Uniform Flow, Determine Flowrate
//===================================================================
model Ex10_3

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real A(unit = "ft^2")"Area of flow domain";
Real P(unit = "ft")"Perimeter of flow domain";
Real R(unit = "ft")"Hydraulic radius";
Real Q(unit = "ft^3/s")"Flow rate";
Real Fr(unit = "")"Froude Number";

//=============
// Parameter Section 

parameter Real S_o(unit = "")=0.0014"Bottom slope";
parameter Real y(unit = "ft")=5"Depth of water";
parameter Real l(unit = "ft")=12"Length of trapizoid domain";
parameter Real theta(unit = "Deg")=40"Angle of trapizoidal flow domain";
parameter Real g(unit ="ft/s^2")=32.2"Acceleration due to gravity";

//=============
// Equation Section 

equation

A = ((l*y)+ (y*(y/(tan(40*(pi/180))))));//Calculation of area of flow domain

P = l + 2*(y/sin(40*(pi/180)));//Calculation of perimeter of flow domain

R = A/P;//Calculation of hydraulic radius

Q = (1.49/0.012)*(A)*((R)^(2/3))*((S_o)^(1/2));//Calculation of flow rate

Fr = ((Q/A)/sqrt(g*y));//Calculation of Froude Number

end Ex10_3;
//===================================================================
