// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-11: Compressible Flow
//Example: 11.11 Page 655
// Title: Choked and Non-choked Fanno Flow
//========================================================================
model Ex11_11

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real M_max(unit = "kg/s")"Maximum Mass flowrate in system";
Real M_maxb(unit = "kg/s")"Maximum Mass flowrate in system for b";
Real P1(unit = "kPa")"Pressure at station 1";
Real P2(unit = "kPa")"Pressure at station 2";
Real P2b(unit = "kPa")"Pressure at station 2 for b";
Real P2c(unit = "kPa")"Pressure at station 2 for c";
Real T1(unit = "K")"Temperature at station 1";
Real T2(unit = "K")"Temperature at station 2";
Real T2b(unit = "K")"Temperature at station 2 for b";
Real M1(unit = "")"Mach Number at station 1";
Real M1b(unit = "")"Mach Number at station 1 for b";
Real M1c(unit = "")"Mach Number at station 1 for c";
Real M2(unit = "")"Mach Number at station 2";
Real Po2(unit ="kPa")"Stagnation pressure at station 2";
Real To2(unit ="K")"Stagnation temperature at station 2";

//=============
// Parameter Section 

parameter Real Po(unit = "kPa")=101"Stagnation Pressure";
parameter Real To(unit = "K")=288"Stagnation Temperature";
parameter Real l(unit = "m")=2"Length of the circular duct";
parameter Real lb(unit = "m")=1"Length of the circular duct for b";
parameter Real D(unit = "m")=0.1"Diameter of the circular duct";
parameter Real f(unit = "")=1"Friction factor for the circular duct";
parameter Real Aoa(unit = "in^2")=0.01"Outside area for config. a";
parameter Real Aia(unit = "in^2")=0.02"Inside area for config. a";
parameter Real Aob(unit = "in^2")=0.02"Outside area for config. a";
parameter Real Aib(unit = "in^2")=0.01"Inside area for config. b";
parameter Real k(unit = "")=1.4"Specific heat ratio";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
parameter Real R(unit = "N.m/kg.K")=286.9"Gas constant";

//=============
// Equation Section 

equation

M1 = 0.63;//Calculation of Mach Number at station 1
//Note: The value is obtained from f(l/D) value from Table D.F

P1 = 0.76*Po;//Calculation of pressure at station 1
//Note: The pressure ratio value 0.76 is obtained for M1 using Tale D.I

T1 = 0.93*To;//Calculation of temperature at station 1
//Note: The temperature ratio value 0.93 is obtained for M1 using Tale D.I

M_max = ((sqrt(k/R)*(((P1*1000)*((pi/4)*(D^2))*M1)/sqrt(T1))));//Calculation of  maximum flow rate

M2 = 1;//Calculation of Mach Number at station 2
//Note: The value is obtained from fanno flow equation

P2 = P1/1.7;//Calculation of pressure at station 2
//Note: The pressure ratio value 1.7 is obtained for M1 using Tale D.F

T2 = T1/1.1;//Caculation of temperature at station 2
//Note: The temperature ratio value 1.1 is obtained for M1 using Tale D.F

Po2 = Po/1.13;//Calculation of stagnation pressure at section 2
//Note: The pressure ratio value 1.13 is obtained for M1 using Tale D.F

To2 = To;//Calculation of stagnation temerature at section 2
//Note: The temperature ratio value is 1 using fanno flow equation

M1b = 0.70;//Calculation of Mach Number at station 1 for b
//Note: The value is obtained from f(lb/D) value from Table D.F

P2b = Po*(0.72/1.5);//Calculation of pressure at section 2 for b
//Note: The pressure rato value (0.72/1.5) is obtained for M1b

T2b = To*(2/(k+1));//Calculation of temperature at section 2 for b

M_maxb = ((sqrt(k/R)*(((P2b*1000)*((pi/4)*(D^2))*M2)/sqrt(T2b))));//Calculation of  maximum flow rate

M1c = 0.63;//Calculation of Mach Number at station 1 for c
//Note: The value is obtained from Table D.F for required duct configuration

P2c = P1*(1.5/1.7);//Calculation of pressure at section 2 for c
//Note: The pressure ratio value (1.5/1.7) isobtained for M1c

end Ex11_11;
//=======================================================================
//The answer slightly varies (1.81% deviation) due to rounding off values
