// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-11: Compressible Flow
//Example: 11.14 Page 655
// Title: Rayleigh Flow in a Combustion Chamber
//========================================================================
model Ex11_14

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P2(unit = "psi")"Pressure at exit";
Real T2(unit = "R")"Temperature at exit";
Real To1(unit = "R")"Upstream stagnation temperature";
Real To2(unit = "R")"Downstream stagnation temperature";
Real V2(unit = "ft/s")"Exit velocity";
Real Qmax(unit = "Btu/lbm")"Maximum Heat input";
Real M1(unit = "")"Inlet Mach Number";
Real M2(unit = "")"Exit Mach Number";
Real C(unit = "")"Speed of sound";
//=============
// Parameter Section 

parameter Real P1(unit = "psi")=10"Pressure at inlet";
parameter Real T1(unit = "R")=400"Temperature at inlet";
parameter Real V1(unit = "ft/s")=400"Inlet velocity";
parameter Real Q1(unit = "Btu/lbm")=50"Heat input";
parameter Real k(unit = "")=1.4"Specific heat ratio";
parameter Real R(unit = "ft.lb/lbm.R")=53.3"Gas constant";
parameter Real cp(unit = "Btu/lbm.R")=0.24"Constant pressure ratio";

//=============
// Equation Section 

equation

C = sqrt(k*R*32.2*T1);//Calculation of speed of sound

M1 = V1/C;//Calculation of Mach Number in section 1

To1 = T1/0.9675;//Calculation of upstream stagnation temperature
//Note: The temprature ratio 0.9675 is obtained for M1

To2 = To1 + (Q1/cp);//Calculation of downstream stagnation temperature

M2 = 0.602;//Calculation of Mach number in section 2
//Note: The value is obtained using stagnation temperature ratio from Table D.R

P2 = P1*(1.5902/1.9428);//Calculation of pressure in section 2

T2 = T1*(0.9196/0.6345);//Calculation of temperature in section 2

V2 = M2*sqrt(k*R*32.2*T2);//Calculation of velocity in section 2

Qmax = cp*((To1/0.5465)-To1);//Calculation of maximum heat input 

end Ex11_14;
//===================================================================
