// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-11: Compressible Flow
//Example: 11.5 Page 626
// Title: Supersonic Flow Pitot Tube
//========================================================================
model Ex11_5

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real M(unit = "")"Mach Number";
Real Ts(unit = "R")"Static Temperature";
Real V(unit = "ft/s")"Velocity of flow";

//=============
// Parameter Section 

parameter Real Tt(unit = "R")=1000"Total Temperature";
parameter Real Pt(unit = "psi")=60"Total Pressure";
parameter Real Ps(unit = "psi")=12"Static Pressure";
parameter Real k(unit = "")=1.4"Specific heat ratio";
parameter Real R(unit = "ft.lb/lbm.R")=53.3"Gas constant";

//=============
// Equation Section 

equation

M = 1.9;//Calculation of Mach Number
//Note: The value is obtained from Graph D.S(or Eqn 2) for Pt/Ps =5 and k=1.4

Ts = 0.59*Tt;//Calculation of static temperature
//Note: The value 0.59 is obtained from Graph D.I for M =1.9

V = M*sqrt(R*k*Ts)*sqrt(32.2);//Calculation of velocity of flow

end Ex11_5;
//========================================================================
//The answer slightly varies (1.89% deviation) due to rounding off values
