// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-11: Compressible Flow
//Example: 11.8 Page 640
// Title: Design of a Compressible Flow Passage
//========================================================================
model Ex11_8

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Pi(unit = "kPa")"Pressure at inlet";
Real Me(unit = "")"Mach Number at exit";
Real Mi(unit = "")"Mach Number at inlet";
Real Ai(unit = "m^2")"Area at inlet";
Real Ae(unit = "m^2")"Area at exit";
Real Ath(unit = "m^2")"Area of the throat";
Real F(unit = "N")"Force";
//=============
// Parameter Section 

parameter Real Po(unit = "kPa")=275"Stagnation Pressure";
parameter Real To(unit = "K")=700"Stagnation Temperature";
parameter Real Pe(unit = "kPa")=101.33"Pressure at exit";
parameter Real m(unit = "kg/s")=82"Mass flow rate";
parameter Real D(unit = "m")=0.6"Diameter of jet";
parameter Real k(unit = "")=1.4"Specific heat ratio";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
parameter Real R(unit = "N.m/kg.K")=265"Gas constant";

//=============
// Equation Section 

equation

Me = 1.285;//Calculation of Mach Number at exit
//Note:The value of Me is obtained for pressure ratio (Pe/Po = 0.6847) in Table D.I

Ath = (m*sqrt(R*To))/(0.6847*(Po*1000));//Calculation of area at throat

Ai = ((pi/4)*D^2);//Calculation of area at inlet

Ae = Ath*1.0601;//Calculation of area at exit
//Note: The value of area ratio (1.0601) for Me value in Table D.I

Mi = 0.419;//Calculation of Mach Number at inlet
//Note: The value of Mi is obtained for area ratio (Ai/Ath = 1.5319) in Table D.I

Pi = Po*0.8862;//Calculation of pressure at inlet
//Note: The value of pressure ration (0.8862) for Mi value in Table D.I

F = ((Pe*1000)*Ae*(1+(k*Me^2)))-((Pi*1000)*Ai*(1+(k*Mi^2)))+((Pe*1000)*(Ai-Ae));
//Calculation of force
//Note: The pressure terms are multiplied by 1000 to convert to Pa

end Ex11_8;
//===================================================================
//The answer given in the text book for Inlet Area and Force is wrong
