// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-12: Turbomachines
//Example: 12.2 Page 691
// Title: Centrifugal Pump Performance Based on Inlet/Outlet Velocities
//========================================================================
model Ex12_2

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Vt2(unit = "ft/s")"Tangential velocity";
Real hi(unit ="ft")"Ideal head rise";
Real W_shaft(unit = "hp")"Work Done by shaft";
Real U2(unit = "ft/s")"Tip velocity";
Real Vr2(unit = "ft/s")"Radial velocity";


//=============
// Parameter Section 

parameter Real b(unit = "in")=2"Uniform blade height";
parameter Real r1(unit = "in")=1.9"Radius 1";
parameter Real r2(unit = "in")=7.0"Radius 2";
parameter Real theta(unit = "Deg")=23"Blade angle";
parameter Real S(unit"rpm")=1750"Pump speed";
parameter Real Q(unit = "gpm")=1400"Flow rate";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
parameter Real rho(unit = "slug/ft^3")=1.94"Density of water";

//=============
// Equation Section 

equation

U2 = ((r2/12)*(S*(2*pi)/60));//Calculation of tip velocity
//Note: The term S is multiplied by (2*pi)/60 to convert to rad/s
//      Division of term r2 by 12 to convert to ft

Vr2 = Q/((7.48*60)*(2*pi)*(r2/12)*(b/12));//Calculation of radial velocity
//Note: Division of term Q by 7.48*60 to convert to ft^3/s
//      Division of term r2,b by 12 to convert to ft

Vt2 = (U2 - (Vr2*(1/tan(theta*(pi/180)))));//Calculation of tangential velocity
//Note: Multiplication of term theta by pi/180 to convert to radians

hi = (U2*Vt2)/g;//Calculation of ideal head rise

W_shaft = ((rho)*((Q)/(7.48*60))*U2*Vt2)/550;//Calculation of work done by shaft
//Note: Division of term Q by 7.48*60 to convert to ft^3/s
//      Division of the expression by 550 to convert W to hp

end Ex12_2;
//===================================================================
