// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-12: Turbomachines
//Example: 12.3 Page 695
// Title: Net Positive Suction Head
//========================================================================
model Ex12_3

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real zmax(unit = "ft")"Maximum height of pump";


//=============
// Parameter Section 

parameter Real D(unit = "in")=4"Diameter ofthe pump";
parameter Real NPSH(unit = "ft")=15"Net ositive Suction Head";
parameter Real Q(unit = "ft^3/s")=0.5"Flow rate";
parameter Real Kl(unit = "")=20"Loss coefficient";
parameter Real Patm(unit = "psi")=14.7"Atmospheric pressure";
parameter Real Pv(unit = "psi")=0.5069"Pressure of water vapour";
parameter Real SW(unit = "lb/ft^3")=62.22"Specific weight of water vapour";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";

//=============
// Equation Section 

equation

zmax = ((Patm*144)/SW) - (Kl*(Q/((pi/4)*(D/12)^2))^2/(2*g)) - ((Pv*144)/SW) - NPSH;//Calculation of maximum height of the pump
//Note: Multiplication of term Patm, Pv by 144 to convert to lb/ft^2
//      Division of term D by 12 to convert to ft


end Ex12_3;
//===================================================================
