model Ex2_11_b
  // Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016
  //Chapter-2: Fluid Statics
  //Example: 2.11.b Page 76
  // Title: Pressure Variation in an Accelerating Tank
  //===================================================================
  //===============
  // Libraries
  extends Modelica.Constants;
  //=============
  // Variable Section
  Real ay_max(unit = "ft/s^2") "Maximum acceleration before fuel drops below the transducer";
  //=============
  // Parameter Section
  parameter Real SG(unit = "") = 0.9 "Specific gravity of fuel";
  parameter Real z(unit = "ft") = 0.5 "Vertical distance between fuel-air interface and the transducer";
  //Refer Fig. E2.11 Page No. 74
  parameter Real y(unit = "ft") = 0.75 "Horizontal distance between the transducer and the vent";
  //Refer Fig. E2.11 Page No. 74
  parameter Real g(unit = "ft/s^2") = 32.2 "Acceleration due to gravity";
  //=============
  // Equation Section
equation
  ay_max = z * g / y;
//Calculation of maximum acceleration before fuel drops below the transducer
end Ex2_11_b;
