// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-2: Fluid Statics
//Example: 2.8 Page 67
// Title: Use of the Pressure Prism Concept
//===================================================================
model Ex2_8

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real F_1(unit = "N")"Magnitude of force due to rectangular portion of pressure distribution";
Real F_2(unit = "N")"Magnitude of force due to triangular portion of pressure distribution";
Real F_R(unit = "N")"Magnitude of resultant force";
Real y(unit = "m")"Vertical location of resultant force";

//=============
// Parameter Section 

parameter Real SG_oil(unit = "")=0.9"Specific gravity of oil";
parameter Real SW(unit = "kN/m^3")=9.81"Specific weight of air";
parameter Real s(unit = "m")=0.6"side of plate";
parameter Real h1(unit = "m")=2"Distance of top surface of prism element from oil surface";
parameter Real h2(unit = "m")=2.6"Distance of bottom surface of prism element from oil surface";
parameter Real P_s(unit = "kN/m^2")=50"Gage pressure of air";
parameter Real y1(unit = "m")=0.3"Vertical location of force due to rectangular portion";
parameter Real y2(unit = "m")=0.2"Vertical location of force due to rectangular portion";

//=============
// Equation Section 

equation
F_1 = ((P_s*1000) + (SG_oil*(SW*1000)*h1))*(s*s);
//Calculation of magnitude of force due to rectangular portion of pressure distribution
//Note: Multiplication of P_s by 1000 to convert to N/m^2
//      Multiplication of SW by 1000 to convert to N/m^2

F_2 = SG_oil*(SW*1000)*((h2-h1)/2)*(s*s);
//Calculation of magnitude of force due to triangular portion of pressure distribution
//Note: Multiplication of SW by 1000 to convert to N/m^2

F_R = F_1 + F_2;
//Calculation of magnitude of resultant force

y = ((F_1*y1)+(F_2*y2))/F_R;
//Calculation of vertical location of resultant force  

end Ex2_8;
//===================================================================
