// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016  

//Chapter-3: Elementary Fluid Dynamics—The Bernoulli Equation
//Example: 3.10 Page 125
// Title: Siphon and Cavitation
//===================================================================
model Ex3_10

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real z2(unit = "ft")"Distance between maximum elevation of hose and tank bottom";//Refer Figure E3.10b Page No. 126
Real V(unit = "ft/s")"Speed of fluid  in hose";
Real P_vap(unit = "psi") "Vapour pressure of water";
Real P_2(unit = "psi")"Pressure at the maximum elevation of the hose";

//=============
// Parameter Section 

parameter Real z1(unit = "ft")=15"Distance between water top surface and tank bottom";
parameter Real z3(unit = "ft")=-5"Distance between tank bottom and end of the hose";//Refer Figure E3.10b Page No. 126
parameter Real P_atm(unit = "psi")=14.7"Atmospheric pressure";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
parameter Real SW(unit = "lb/ft^3")=62.4"Specific weight of water";
parameter Real rho(unit = "slug/ft^3")=1.94"Density of water";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation
V = sqrt(2*g*(z1-z3));//Calculation of Speed of fluid  in hose

P_vap = 0.256; //Calculation of vapour pressure of water at 60 F
//Refer Table B.1 in page no. 758 to get the value

P_2 = P_vap - P_atm;//Calculation of Pressure at the maximum elevation of the hose

z2 = z1 - ((P_2*144) + ((rho*V^2)/2))/SW;//Calculation of distance between maximum elevation of hose and tank bottom
//Note: Multiplication of P_2 by 144 to convert to lb/ft^2 

end Ex3_10;
//===================================================================
