// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-3: Elementary Fluid Dynamics—The Bernoulli Equation
//Example: 3.17 Page 136
// Title: Unsteady or Steady Flow
//===================================================================
model Ex3_16

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P_2(unit = "kPa")"Stagnation pressure at the nose of submarine";//Refer Figure E3.17-page no. 130

//=============
// Parameter Section 

parameter Real SG(unit = "")=1.03"Specific gravity of sea water";
parameter Real SW(unit = "N/m^3")=9800"Specific weight of sea water";
parameter Real h(unit = "m")=50"Depth of submarine below water surface";
parameter Real V(unit = "m/s")=5.0"Velocity of submarine";
parameter Real rho_water(unit = "kg/m^3")=1000"Density of water";

//=============
// Equation Section 

equation
P_2 = ((((SG*rho_water)*V^2)/2) + (SW*SG*h))/1000;//Calculation of Stagnation pressure at the nose of submarine
//Note: Division of the expression by 1000 to convert P_2 to kPa

end Ex3_16;
//===================================================================
