// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.12 Page 217
// Title: Linear Momentum—Pressure and Change in Flow Direction
//===================================================================
model Ex5_12

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real F_x(unit = "lb")"Anchoring force: Horizontal Direction";
Real F_y(unit = "lb")"Anchoring force: Vertical Direction";
Real m(unit = "slug/s")"Mass flow rate";

//=============
// Parameter Section 

parameter Real w(unit = "ft/s")=50"Velocity in the control volume";
parameter Real A(unit = "ft^2")=0.1"Flow area cross-section";
parameter Real P_1(unit = "psi")=30"Pressure at inlet";
parameter Real P_2(unit = "psi")=24"Pressure at exit";
parameter Real P_atm(unit = "psi")=14.7"Atmospheric pressure";
parameter Real rho(unit = "slug/ft^3")=1.94"Density of water";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

F_x = 0;//Calculation of anchoring force in horizontal Direction
//Note: There is no x direction momentum flow into or out of the control volume

m = rho*A*w;//Calculation of mass flow rate

F_y = -(m*(w+w))-((P_1-P_atm)*144*A)-((P_2-P_atm)*144*A);//Calculation of anchoring force in vertical Direction
//Note: Multiplication of pressure terms by 144 to convert to lb/ft^2

end Ex5_12;
//===================================================================
