// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.17 Page 224
// Title: Linear Momentum—Moving Control Volume
//===================================================================
model Ex5_17

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real F_x(unit = "lb")"Force: x-direction";
Real F_z(unit = "lb")"Force: z-direction";
Real F(unit = "lb")"Resultant force";
Real alpha(unit = "Deg")"Angle of resultant force";
Real W1(unit = "ft/s")"Relative speed of the stream of water";

//=============
// Parameter Section 

parameter Real A(unit = "ft^2")=0.006"Area of the nozzle";
parameter Real l(unit = "ft")=1"Length of pipe";
parameter Real V_1(unit = "ft/s")=100"Speed of the water jet leaving the nozzle";
parameter Real V_0(unit = "ft/s")=20"Speed of vane on wheels";
parameter Real theta(unit = "Deg")=45"Angle between moving vane and nozzle";
parameter Real rho(unit = "slug/ft^3")=1.94"Density of water";
parameter Real SW(unit = "lb/ft^3")=62.4"Specific weight of water";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

W1 = V_1 - V_0;//Calculation of relative speed of the stream of water

F_x = rho*W1^2*A*(1-cos(theta*(pi/180)));//Calculation of Force: x-direction
//Note: Multipilcation of term theta by pi/180 to convert to radians

F_z = (rho*W1^2*sin(theta*(pi/180))*A) + (SW*l*A);//Calculation of Force: z-direction
//Note: Multipilcation of term theta by pi/180 to convert to radians

F = sqrt((F_x)^2 + (F_z)^2);//Calculation of resultant force

alpha = atan(F_z/F_x)*(180/pi);//Calculation of angle of resultant force
//Note: Multipilcation of term by 180/pi to convert to degrees

end Ex5_17;
//===================================================================
