// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.18 Page 230
// Title: Moment-of-Momentum—Torque
//===================================================================
model Ex5_18

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real m(unit = "kg/s")"Mass flow rate of water";
Real T_1(unit = "N.m")"Resisting torque for (a)";
Real V_2(unit = "m/s")"Absolute velocity of fluid";
Real T_2(unit = "N.m")"Resisting torque for (b)";
Real omega_2(unit = "rev/min")"Revolution of the sprinkler for zero resisting torque";

//=============
// Parameter Section 

parameter Real Q(unit = "ml/s")=1000"Flow rate of water";
parameter Real A(unit = "mm^2")=30"Exit area of the nozzle";
parameter Real R(unit = "mm")=200"Radius from the axis of rotation to the centerline of nozzle";
parameter Real rho(unit = "kg/m^3")=999"Density of water";
parameter Real W_2(unit = "m/s")=16.7"Speed of the fluid relative to nozzle";
parameter Real omega_1(unit = "rev/min")=500"Revolution of the sprinkler";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

m = (Q*10^(-6))*rho;//Calculation of mass flow rate
//Note: Multiplication of term Q by 10^-6 to convert to m^3/s

T_1 = -(R/1000)*W_2*m;//Calculation of Resisting torque for (a)
//Note: Division of term R by 1000 to convert to m

V_2 = W_2 - ((R/1000)*(omega_1*(2*pi/60)));//Calculation of absolute velocity of fluid
//Note: Division of term R by 1000 to convert to m
//      Multiplication of term omega_1 by 2*pi/60 to ocnvert to rad/s

T_2 = -(R/1000)*V_2*m;//Calculation of Resisting torque for (a)
//Note: Division of term R by 1000 to convert to m

omega_2 = (W_2/(R/1000))*(60/(2*pi));//Calcuation of revolution of the sprinkler for zero resisting torque
//Note: Division of term R by 1000 to convert to m
//      Multiplication of term by 60/(2*pi) to convert to rev/min.

end Ex5_18;
//===================================================================
