// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.2 Page 201
// Title: Conservation of Mass—Steady, Compressible Flow
//===================================================================
model Ex5_2

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Vavg_1(unit = "ft/s")"Mean air velocity at section 1";

//=============
// Parameter Section 

parameter Real P_1(unit = "psi")=100"Pressure at section 1";
parameter Real T_1(unit = "R")=540"Temperature at section 1";
parameter Real Vavg_2(unit = "ft/s")=1000"Mean air velocity at section 2";
parameter Real P_2(unit = "psi")=18.4"Pressure at section 2";
parameter Real T_2(unit = "R")=453"Temperature at section 2";

//=============
// Equation Section 

equation
Vavg_1 = (P_2*T_1*Vavg_2)/(P_1*T_2);//Calculation of Mean air velocity at section 1
//Note: The expression is obtained from continuity equation satisfying for compressible flow

end Ex5_2;
//===================================================================
