// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.22 Page 240
// Title: Energy—Temperature Change
//===================================================================
model Ex5_22

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real T(unit = "R")"Temperature change associated with flow";

//=============
// Parameter Section 

parameter Real H(unit = "ft")=420"Height of waterfall";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
parameter Real C(unit = "ft.lb/lbm.R")=778"Specific heat of water";

//=============
// Equation Section 

equation

T = (g*H)/(C*32.2);//Calculation of temperature change associated with flow
//Note: Multiplication of c by 32.2 to convert to ft/s^2

end Ex5_22;
//===================================================================
