// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.26 Page 248
// Title: Energy—Effect of Nonuniform Velocity Profile
//===================================================================
model Ex5_26

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real l_ass(unit = "N.m/kg")"Loss: Assuming uniform velocity distributions";
Real l_act(unit "N.m/kg")"Loss: Considering actual velocity distributions";
Real W(unit = "N.m/kg")"Shaft work";
Real V1(unit = "m/s")"Average velocity at section 1";
Real V2(unit = "m/s")"Average velocity at section 2";

//=============
// Parameter Section 

parameter Real P(unit = "W")=0.14"Power to fan motor";
parameter Real m(unit = "kg/min")=0.1"Mass flow rate";
parameter Real D1(unit = "mm")=60"Diameter at section 1";
parameter Real D2(unit = "mm")=30"Diameter at section 2";
parameter Real rho(unit = "kg/m^3")=1.23"Density of air";
parameter Real P_rise(unit = "kPa")=0.1"Pressure rise";
parameter Real KE_1(unit ="")=2"Kinetic energy coefficient at section 1";
parameter Real KE_2(unit ="")=1.08"Kinetic energy coefficient at section 2";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

W = P/(m/60);//Calculation of shaft power
//Note: Division of term m by 60 to convert to kg/s

V1 = (m/60)/(rho * ((pi/4)*(D1/1000)^2));//Calculation of average velocity at section 1
//Note: Division of term D1 by 1000 to convert to m
//      Division of term m by 60 to convert to kg/s

V2 = (m/60)/(rho * ((pi/4)*(D2/1000)^2));//Calculation of average velocity at section 2
//Note: Division of term D2 by 1000 to convert to m
//      Division of term m by 60 to convert to kg/s

l_ass = W - ((P_rise*1000)/rho) + (V1^2/2) - (V2^2/2); //Calculation of Loss: Assuming uniform velocity distributions
//Note: Multiplication of term P_rise by 1000 to convert to Pa

l_act = W - ((P_rise*1000)/rho) + (KE_1*(V1^2/2)) - (KE_2*(V2^2/2)); //Calculation of Loss: Considering actual velocity distributions
//Note: Multiplication of term P_rise by 1000 to convert to Pa

end Ex5_26;
//===================================================================
