// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.3 Page 202
// Title: Conservation of Mass—Two Fluids
//===================================================================
model Ex5_3

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real M_2(unit = "lb/hr")"Mass flowrate of the dry air and the water vapor leaving the dehumidifier";

//=============
// Parameter Section 

parameter Real M_1(unit = "lb/hr")=600"Mass flowrate of the Moist air (a mixture of dry air and water vapor) entering the dehumidifier";
parameter Real M_3(unit = "lb/hr")=3"Mass flowrate of the Liquid water draining out of the dehumidifier";

//=============
// Equation Section 

equation
M_2 = M_1 - M_3;//Calculation of mass flowrate of the dry air and the water vapor leaving the dehumidifier
//Note: The expression is obtained from the mass conservation expression
end Ex5_3;
//===================================================================
