// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.6 Page 207
// Title: Conservation of Mass—Compressible Flow with a Moving Control Volume
//===================================================================
model Ex5_6

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Q(unit = "kg/hr")"Mass flowrate of fuel into the engine";
Real V_e(unit = "km/hr")"Actual Speed of exhaust gas of the airplane";

//=============
// Parameter Section 

parameter Real V_a(unit = "km/hr")=971"Speed of airplane";
parameter Real A_f(unit = "m^2")=0.8"Frontal intake area of the jet engine";
parameter Real rho_1(unit = "kg/m^3")=0.736"Entering air density";
parameter Real V_rel(unit = "km/hr")=1050"Speed of exhaust gas of the airplane relative to earth";
parameter Real A_e(unit = "m^2")=0.558"engine exhaust area";
parameter Real rho_2(unit = "ft^3/min")=0.515"Exhaust air density";

//=============
// Equation Section 

equation
V_e = V_rel + V_a;//Calculation of actual Speed of exhaust gas of the airplane

Q = (rho_2*A_e*V_e*1000)-(rho_1*A_f*V_a*1000);//Caculation of mass flowrate of fuel into the engine
//Note: Mutiplication by 1000 to convert V_e and V_a to m/hr

end Ex5_6;
//===================================================================
//The answer for mass flowrate of fuel in the book is wrong
