// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-6: Differential Analysis of Fluid Flow
//Example: 6.10 Page 331
// Title: Laminar Flow in an Annulus
//===================================================================
model Ex6_10

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P(unit = "kPa")"Pressure Drop: Normal pipe flow";
Real P_ann(unit = "kPa")"Pressure Drop: Annulus pipe flow";
Real V(unit = "m/s")"Mean velocity of the fluid";
Real V_ann(unit = "m/s")"Mean velocity of the fluid for annulus pipe flow";
Real Re(unit = "")"Reynods number";
Real Re_ann(unit = "")"Reynods number for annulus pipe flow";

//=============
// Parameter Section 

parameter Real Q(unit = "ml/s")=12"Volume flow rate";
parameter Real D(unit = "mm")=4"Diameter of the tube";
parameter Real l(unit = "m")=1"Length of the tube";
parameter Real d(unit = "mm")=2"Diameter of the rod";
parameter Real rho(unit = "kg/m^3")=1180"Fluid density";
parameter Real mu(unit = "N.s/m^2")=0.0045"Fluid viscosity";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

V = (Q*10^(-6))/((pi/4)*(D/1000)^2);//Calculation of mean velocity
//Note: Division of D by 1000 to convert to m
//      Multiplication of Q by 10^-6 to convert to m^3/s

Re = (rho*V*(D/1000))/mu;//Calculation of Reynolds number
//Note: This is done to get the nature of flow

P = ((8*mu*l*(Q*10^(-6)))/(pi*((D/2)/1000)^4))/1000;//Calculation of pressure drop in normal pipe flow
//Note: From the Re  value the flow is ascertained to be laminar. So, the above expression is used. //  //      Division of D/2 by 1000 to convert to m
//      Multiplication of Q by 10^-6 to convert to m^3/s
//      Division of the whole expression by 1000 to convert unit of P to kPa

V_ann = (Q*10^(-6))/((pi/4)*((D/1000)^2 - (d/1000)^2));//Calculation of mean velocity of fluid for annulus pipe flow

Re_ann = (rho*V_ann*((D-d)/1000))/mu;//Calculation of Reynolds number for annulus pipe flow

P_ann = (((8*mu*l*(Q*10^(-6)))/pi)/(((D/2)/1000)^4 - ((d/2)/1000)^4 - ((((D/2)/1000)^2-((d/2)/1000)^2)^2/(log(D/d)))))/1000;
//Calculation of pressure drop in annulus pipe flow
//Note: From the Re_ann value the flow is ascertained to be laminar. So, the above expression is used.   //      Division of D/2,d/2 by 1000 to convert to m
//      Multiplication of Q by 10^-6 to convert to m^3/s
//      Division of the whole expression by 1000 to convert unit of P_ann to kPa

end Ex6_10;
//===================================================================
