// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-7: Dimensional Analysis, Similitude, and Modeling
//Example: 7.8 Page 383
// Title: Froude Number Similarity
//===================================================================
model Ex7_8

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Q_m(unit = "m^3/s")"Flowrate of the model";
Real w_m(unit = "m")"width of the model";
Real t_m(unit = "hr")"time interval of the model";

//=============
// Parameter Section 

parameter Real Q(unit = "m^3/s")=125"Flowrate of the prototype";
parameter Real w(unit = "m")=20"width of the prototype";
parameter Real t(unit = "hr")=24"time interval of the prototype";
parameter Real l(unit = "")=1/15"Length scale";

//=============
// Equation Section 

equation

w_m = l*w;//Calculation of width of the model

Q_m = (l)^(5/2)*Q;//Calculation of flowrate of the model

t_m = sqrt(l)*t;//Calculation of time interval of the model

end Ex7_8;
//===================================================================
