// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.12 Page 453
// Title: Type III without Minor Losses, Determine Diameter
//===================================================================
model Ex8_12

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real f(start = 0.02, unit ="")"Friction factor";//Initial guess value is 0.02
Real D(unit = "ft")"Diameter of the pipe";
Real Re(unit ="")"Reynolds Number";
Real r(unit ="")"Ratio of roughness with pipe diameter (e/D)";

//=============
// Parameter Section 

parameter Real Q(unit = "ft^3/s")=2"Flowrate of fluid";
parameter Real rho(unit = "slug/ft^3")=0.00238"Density of fluid";
parameter Real mu(unit = "lb.s/ft^2")=0.000000374"Viscoisty of fluid";
parameter Real e(unit = "ft")=0.0005"Roughness of pipe";

//=============
// Equation Section 

equation


D  = 0.404*((f)^(1/5));//Calculation of Diameter of the pipe

Re = rho*(Q/((pi/4)*D^2))*D/mu;//Calculation of Reynolds Number

r = e/D;//Calculation of roughness ratio

(1/sqrt(f)) = -2.0*log10((r/3.7)+(2.15/(Re*sqrt(f))));//Calculation of friction factor
//Colebrrok Equation

end Ex8_12;
//===================================================================
