// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.8 Page 447
// Title: Type I, Determine Pressure Drop
//===================================================================
model Ex8_8

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P(unit = "psi")"Pressure drop when all losses are neglected";
Real f(unit = "")"Friction factor";
Real P_major(unit = "psi")"Pressure drop when major loss is included";
Real P_total(unit = "psi")"Pressure drop when all losses are included";

//=============
// Parameter Section 

parameter Real SW(unit = "lb/ft^3")=62.4"Specific weight of water";
parameter Real z2(unit = "ft")=20"Height of pipe";
parameter Real l(unit = "ft")=60"Total length of pipe";
parameter Real D(unit = "ft")=0.0625"Diameter of pipe";
parameter Real rho(unit= "slug/ft^3")=1.94"Density of water";
parameter Real V2(unit= "ft/s")=19.6"Velocity at section 2";
parameter Real V1(unit= "ft/s")=8.7"Velocity at section 1";
parameter Real Kle(unit = "")=1.5"Loss coefficient for elbow";
parameter Real Klw(unit = "")=10"Loss coefficient for wide opening";
parameter Real Klf(unit = "")=2"Loss coefficient for faucet";

//=============
// Equation Section 

equation

P = ((SW*z2)+((1/2)*(rho)*(V2^2-V1^2)))/144;//Calculation of pressure drop without any loss
//Note: The whole expression is divided by 144 to convert P to psi units

f = 0.021;//Calculation of friction factor
//Note: The above value is obtained from Moody chart

P_major = ((SW*z2)+((1/2)*(rho)*(V2^2-V1^2))+(rho*f*(l/D)*(V1^2/2)))/144;
//Calculation of pressure drop with major loss
//Note:The whole expression is divided by 144 to convert P_major to psi units

P_total = ((SW*z2)+((1/2)*(rho)*(V2^2-V1^2))+(rho*f*(l/D)*(V1^2/2))+(rho*(V1^2/2)*(Klw+(4*Kle)+Klf)))/144;
//Calculation of pressure drop with all loss included
////Note:The whole expression is divided by 144 to convert P_major to psi units

end Ex8_8;
//===================================================================
