// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-9: General External Flow Characteristics
//Example: 9.1 Page 485
// Title: Drag from Pressure and Shear Stress Distributions
//===================================================================
model Ex9_1

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real D_parallel(unit = "lb")"Drag on the plate: Plate parallel to the fluid flow";
Real D_perpendicular(unit = "lb")"Drag on the plate: Plate perpendicular to the fluid flow";
Real L_parallel(unit = "lb")"Lift on the plate: Plate parallel to fluid flow";
Real L_perpendicular(unit = "lb")"Lift on the plat: Plate perpendicular to fluid flow";


//=============
// Parameter Section 


parameter Real w(unit = "ft")=10"Width of the plate";
parameter Real l(unit = "ft")=4"Length of the plate";
parameter Real y_1(unit = "ft")=-2"y-coordinate at start of plate";
parameter Real y_2(unit = "ft")=2"y-coordinate at end of plate";

//=============
// Equation Section 

equation

D_parallel = 2*(2*(0.00124*sqrt(l))*w);//Calculation of Drag on the plate: Plate parallel to the fluid flow

L_parallel = 0; //Calculation of Lift on the plate: Plate parallel to fluid flow
//Note: Lift is zero because Pressure force is parallel to upstream flow

D_perpendicular = (0.744*((y_2-y_1)-((y_2^3-y_1^3)/12))-(-0.893*(y_2-y_1)))*w;//Calculation of Drag on the plate: Plate perpendicular to the fluid flow

L_perpendicular = 0; //Calculation of Lift on the plate: Plate perpendicular to fluid flow
//Note: Lift is zero because Pressure force is parallel to upstream flow

end Ex9_1;
//===================================================================
