// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-9: General External Flow Characteristics
//Example: 9.10 Page 522
// Title: Low Reynolds Number Flow Drag
//===================================================================
model Ex9_10

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real t(unit = "s")"Time taken for particle to fall";
Real U(unit = "m/s")"Velocity of particle";

//=============
// Parameter Section
 
parameter Real mu(unit = "lb.s/ft^2")=0.0000179"Viscosity of air";
parameter Real SG(unit = "")=1.2"SPecific gravity";
parameter Real SW_water(unit = "N/m^3")=9800"Specific weight of water";
parameter Real SW(unit = "N/m^3")=12.0"Specific weight of air";
parameter Real D(unit = "m")=0.00001"Diameter of particle";
parameter Real H(unit = "ft")=8"Height of particle from floor";
//=============
// Equation Section 

equation

U = (D^2*((SG*SW_water)-SW))/(18*mu);//Calculation of velocity of particle

t = (H*0.3048)/U;//Calculation of time taken for particle to fall

end Ex9_10;
//===================================================================
