// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-9: General External Flow Characteristics
//Example: 9.12 Page 528
// Title: Effect of Surface Roughness
//===================================================================
model Ex9_12

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real D1(unit = "")"Drag force of golf ball";
Real D2(unit = "")"Drag force of smooth golf ball";
Real D3(unit = "")"Drag force of table tennis ball";
Real A1(unit = "")"Deceleration ratio of golf ball";
Real A2(unit = "")"Deceleration ratio of smooth golf ball";
Real A3(unit = "")"Deceleration ratio of table tennis ball";

//=============
// Parameter Section
 
parameter Real rho(unit = "slug/ft^3")=0.00238"Density of air";
parameter Real U_golf(unit = "ft/s")=200"Velocity of golf ball"; 
parameter Real U_tt(unit = "ft/s")=60"Velocity of table tennis ball";
parameter Real W_golf(unit = "lb")=0.0992"Weight of golf ball"; 
parameter Real W_tt(unit = "lb")=0.00551"Weight of table tennis ball";
parameter Real D_golf(unit = "in")=1.69"Diameter of golf ball"; 
parameter Real D_tt(unit = "in")=1.50"Diameter of table tennis ball";
parameter Real Cd1(unit = "")=0.25"Drag coefficient of gold ball";
parameter Real Cd2(unit = "")=0.51"Drag coefficient of smooth gold ball";
parameter Real Cd3(unit = "")=0.50"Drag coefficient of table tennis ball";

//=============
// Equation Section 

equation

D1 = ((1/2)*rho*(U_golf^2)*((pi/4)*(D_golf/12)^2)*Cd1);//Calculation of drag force on the golf ball

D2 = ((1/2)*rho*(U_golf^2)*((pi/4)*(D_golf/12)^2)*Cd2);//Calculation of drag force on the smooth golf ball

D3 = ((1/2)*rho*(U_tt^2)*((pi/4)*(D_tt/12)^2)*Cd3);//Calculation of drag force on the table tennis ball

A1 = (D1/W_golf);//Calculation of Deceleration ratio of golf ball

A2 = (D2/W_golf);//Calculation of Deceleration ratio of smooth golf ball

A3 = (D3/W_tt);//Calculation of Deceleration ratio of table tennis ball

end Ex9_12;
//===================================================================
