// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-9: General External Flow Characteristics
//Example: 9.16 Page 544
// Title: Lift on a Rotating Sphere
//===================================================================
model Ex9_16

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Cl(unit = "")"Lift Coefficint";
Real omega(unit = "rpm")"Angular acceleration of ball";

//=============
// Parameter Section
 
parameter Real rho(unit = "kg/m^3")=1.23"Density of air";
parameter Real U(unit = "m/s")=12"Speed of the ball"; 
parameter Real W(unit = "N")=0.0245"Wight of the ball";
parameter Real D(unit = "m")=0.038"Diameter of the ball";

//=============
// Equation Section 

equation

Cl = (2*W)/(rho*(U)^2*((pi/4)*(D^2)));//Calculation of lift coefficient

omega = ((2*U*0.9)/D)*(60/(2*pi));//Calculation of angular acceleration
//Note: The expression is multiplied by 60/(2*pi) to convert omega to rpm
// The expression obtained for omega is obtained from Fig. 9.39 in Page No. 543 for Cl value obtained

end Ex9_16;
//===================================================================
