// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-9: General External Flow Characteristics
//Example: 9.5 Page 505
// Title: Boundary Layer Transition
//===================================================================
model Ex9_5

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real t_water(unit = "ft")"Boundary layer thickness: water";
Real t_air(unit = "ft")"Boundary layer thickness: air";
Real t_gly(unit = "ft")"Boundary layer thickness: glycerine";
Real x_water(unit = "ft")"Critical Location of Turbulent Boundary layer: water";
Real x_air(unit = "ft")"Critical Location of Turbulent of Boundary layer: air";
Real x_gly(unit = "ft")"Critical Location of Turbulent layer: glycerine";
Real Re_cr(unit = "")"Critical Reynolds number";

//=============
// Parameter Section 

parameter Real nu_water(unit = "ft^2/s")=0.0000121"Viscosity: water";
parameter Real nu_air(unit = "ft^2/s")=0.000157"Viscosity: air";
parameter Real nu_gly(unit = "ft^2/s")=0.0128"Viscosity: glycerine";
parameter Real U(unit = "ft/s")=10"Freestream velocity of fluid";

//=============
// Equation Section 

equation

Re_cr = 500000;//Calculationof critical Reynolds number
//Note: The value is assumed in the problem

x_water = (nu_water*Re_cr)/U;//Calculation of Critical Location of Turbulent Boundary layer: water

t_water = 354*nu_water;//Calculation of Boundary layer thickness: water

x_air = (nu_air*Re_cr)/U;//Calculation of Critical Location of Turbulent Boundary layer: sir

t_air = 354*nu_air;//Calculation of Boundary layer thickness: air

x_gly = (nu_gly*Re_cr)/U;//Calculation of Critical Location of Turbulent Boundary layer: glycerine

t_gly = 354*nu_gly;//Calculation of Boundary layer thickness: glycerine

end Ex9_5;
//===================================================================
