// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-9: General External Flow Characteristics
//Example: 9.7 Page 509
// Title: Drag on a Flat Plate
//===================================================================
model Ex9_7

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real D(unit = "lb")"Drag force on flat plate";
Real C_d(unit = "")"Drag Coefficient";
Real Re(unit = "")"Reynolds number";

//=============
// Parameter Section
 
parameter Real mu(unit = "lb.s/ft^2")=0.0000204"Viscosity of fluid";
parameter Real rho(unit = "slug/ft^3")=1.94"Density of fluid";
parameter Real U(unit = "ft/s")=10"Freestream velocity of fluid";
parameter Real l(unit = "ft")=4"Length of the plate";
parameter Real w(unit = "ft")=0.5"Width of the plate";

//=============
// Equation Section 

equation

Re = (rho*U*l)/mu;//Calculation of reynolds number

C_d = (0.455/((log(Re)/2.303)^(2.58))) - (1700/Re);//Calculation of Drag coefficient
//Note: The term log(Re) is divided by 2.303 to convert from natural log to log to the base 10

D = (1/2)*(rho)*(l*w)*(U^2)*(C_d);//Calculation of Drag force on the plate

end Ex9_7;
//===================================================================
