// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-1: Introduction
//Example: 1.6 Page 21
// Title: Isentropic Compression of a Gas
//===================================================================
model Ex1_6

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P_final(unit = "psi")"Final pressure of air";

//=============
// Parameter Section 

Real P_initial(unit = "psi")=14.7"Initial pressure of air";
parameter Real V_final(unit = "ft^3")=0.5"Final volume of air";
parameter Real V_initial(unit = "ft^3")=1"Initial volume of air";
parameter Real k(unit = "")=1.4"Ratio of specific heat at constant pressure";

//=============
// Equation Section 

equation
P_final = (V_initial/V_final)^(k)*(P_initial);//Calculation of finial pressure of air
//Note: (rho_final/rho_initial) = (V_initial/V_final) because mass of air before and after compression remains the same.

end Ex1_6;
//===================================================================
