// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-1: Introduction
//Example: 1.7 Page 23
// Title: Speed of Sound and Mach Number
//===================================================================
model Ex1_7

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real C(unit = "ft/s")"Speed of sound";
Real M(unit = "")"Mach Number";


//=============
// Parameter Section 

parameter Real k(unit = "")=1.4"Ratio of specific heat at constant pressure";
parameter Real R(unit = "ft.lb/slug.R")=1716"Gas constant";
parameter Real T(unit = "F")=-66"Temperature of air";
parameter Real V(unit = "mi/hr")=550"Air speed";

//=============
// Equation Section 

equation
C = sqrt (k*R*(T+460));//Calculation of speed of sound
//Note: Addition of T by 460 to convert to R

M = (V*((5280)/(3600)))/C; //Calculation of Mach Number
//Note: Multiplication of V by 5280 and division of V by 3600 to convert to ft/s

end Ex1_7;
//===================================================================
