// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-1: Introduction
//Example: 1.8 Page 26
// Title: Capillary Rise in a Tube
//===================================================================
model Ex1_8

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real R(unit = "m")"Minimum tube radius";
Real D(unit = "m")"Minimum tube diameter";

//=============
// Parameter Section 

parameter Real s(unit = "N/m")=0.0728"Surface tension";
parameter Real y(unit = "kN/m^3")=9.789"Specific weight of the liquid";
parameter Real theta(unit = "deg.")=0"Angle of contact";
parameter Real h(unit = "mm")=1.0"Maximum height";

//=============
// Equation Section 

equation
R = (2*s*cos(theta))/((y*1000)*(h*0.001));//Calculation of minimum tube radius
//Note: Multiplication of y by 1000 to convert to N/m^3
//      Multiplication of h by 0.001 to convert to m
D = 2*R;//Calculation of minimum tube diameter

end Ex1_8;
//===================================================================
