// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-10: Open-Channel Flow
//Example: 10.2 Page 568
// Title: Specific Energy Diagram—Quantitative
//===================================================================
model Ex10_2

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real V1(unit = "ft/s")"Velocity of fluid in section 1";
Real V2(unit = "ft/s")"Velocity of fluid in section 2";
Real E(unit = "ft")"Elevation of water surface downstream";
Real y2(unit = "ft")"Downstream depth";

//=============
// Parameter Section 

parameter Real q(unit = "ft^2/s")=5.75"Flow rate";
parameter Real y1(unit = "ft")=2.3"Upstream depth";
parameter Real z2(unit = "ft")=0.5"Distance of ramp from free surface";
parameter Real g(unit ="ft/s^2")=32.2"Acceleration due to gravity";

//=============
// Equation Section 

equation

V1 = q/y1;//Calculation of velocity in section 1

V2 = (y1*V1)/y2;//Calculation of velocity in section 2

y1 + (V1^2/(2*g)) = y2 + (V2^2/(2*g)) + z2;//Calculation of downstream depth

E = y2+z2;//Calculation of Elevation of water surface downstream

end Ex10_2;
//===================================================================
