// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-10: Open-Channel Flow
//Example: 10.4 Page 575
// Title: Uniform Flow, Determine Normal Depth
//===================================================================
model Ex10_4

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real A(unit = "ft^2")"Area of flow domain";
Real P(unit = "ft")"Perimeter of flow domain";
Real R(unit = "ft")"Hydraulic radius";
Real y(unit = "ft")"Depth of water";

//=============
// Parameter Section 

parameter Real S_o(unit = "")=0.0014"Bottom slope";
parameter Real Q(unit = "ft^3/s")=10"Flowrate of water";
parameter Real l(unit = "ft")=3.66"Length of trapizoid domain";
parameter Real theta(unit = "Deg")=40"Angle of trapizoidal flow domain";
parameter Real g(unit ="ft/s^2")=32.2"Acceleration due to gravity";

//=============
// Equation Section 

equation



A = ((l*y)+ (y*(y/(tan(40*(pi/180))))));//Calculation of area of flow domain

P = l + 2*(y/sin(40*(pi/180)));//Calculation of perimeter of flow domain

R = A/P;//Calculation of hydraulic radius

Q = (1.0/0.030)*(A)*((R)^(2/3))*((S_o)^(1/2));//Calculation of flow rate

//((1.19*y^2) + (3.66*y))^5 - 515*((3.11*y)+3.66)^2 = 0;

end Ex10_4;
//===================================================================
