// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-10: Open-Channel Flow
//Example: 10.8 Page 585
// Title: Hydraulic Jump
//===================================================================
model Ex10_8

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Fr1(unit = "")"Froude number in section 1";
Real Fr2(unit = "")"Froude number in section 2";
Real y2(unit ="ft")"Depth of fluid in sction 2";
Real V2(unit ="ft/s")"Velocity of fluid in section 2";
Real P(unit = "hp")"Power dissipated";
Real h(unit = "ft")"Head loss";

//=============
// Parameter Section 

parameter Real w(unit = "ft")=100"Width of flow domain";
parameter Real g(unit ="ft/s^2")=32.2"Acceleration due to gravity";
parameter Real SW(unit ="lb/ft^3")=62.4"Secific weight";
parameter Real V1(unit ="ft/s")=18"Velocity of fluid in section 1";
parameter Real y1(unit ="ft")=0.6"Depth of fluid in section 1";

//=============
// Equation Section 

equation

Fr1 = V1/sqrt(g*y1);//Calculation of Froude Number in section 1

y2 = y1*((1/2)*(-1 + sqrt(1+(8*Fr1^2))));//Calculation of depth of fluid in section 2

V2 = (y1*V1)/y2;//Calculation of velocity of fluid at section 2

Fr2 = V2/sqrt(g*y2);//Calculation of Froude Number in section 2

h = (y1 + (V1^2/(2*g)))-(y2+(V2^2/(2*g)));//Calculation of head loss

P = (SW*w*y1*V1*h)/550;//Calculation of power dissipated
//Note: The expression is divided by 550 to convert P to hp

end Ex10_8;
//===================================================================
